/*
 ---------------------------------------------------------------------------
 Copyright (c) 1998-2008, Brian Gladman, Worcester, UK. All rights reserved.

 LICENSE TERMS

 The redistribution and use of this software (with or without changes)
 is allowed without the payment of fees or royalties provided that:

  1. source code distributions include the above copyright notice, this
     list of conditions and the following disclaimer;

  2. binary distributions include the above copyright notice, this list
     of conditions and the following disclaimer in their documentation;

  3. the name of the copyright holder is not used to endorse products
     built using this software without specific written permission.

 DISCLAIMER

 This software is provided 'as is' with no explicit or implied warranties
 in respect of its properties, including, but not limited to, correctness
 and/or fitness for purpose.
 ---------------------------------------------------------------------------
 Issue Date: 13/10/2006

 This code has been derived from LibTomCrypt, the cryptographic library
 authored by Tom St Denis.  His contribution is hence acknowledged. This
 code has been developed to obtain two independent implementations of the
 combined AES encryption/authentication modes (CCM, GCM and EAX) in order
 to be able to check test vectors before their publication.
*/

#ifndef LTC_CTR_H
#define LTC_CTR_H

#include "aes.h"

#define CTR_COUNTER_LITTLE_ENDIAN    0
#define CTR_COUNTER_BIG_ENDIAN       1

typedef struct
{
    aes_encrypt_ctx ctx[1];
    uint_8t         ctr[AES_BLOCK_SIZE];
    uint_8t         pad[AES_BLOCK_SIZE];
    int             padlen;
    int             mode;
} ctr_ctx;

int ctr_start( const uint_8t iv[],
               const uint_8t key[], int key_len,
               int num_rounds, int ctr_mode, ctr_ctx ctr[1] );

int ctr_encrypt( const uint_8t pt[], uint_8t ct[], unsigned long len, ctr_ctx ctr[1] );

int ctr_decrypt( const uint_8t ct[], uint_8t pt[], unsigned long len, ctr_ctx ctr[1] );

int ctr_setiv( const uint_8t iv[], unsigned long len, ctr_ctx ctr[1] );

int ctr_getiv( uint_8t iv[], unsigned long *len, ctr_ctx ctr[1] );

int ctr_done( ctr_ctx ctr[1] );

#endif
