/*
 ---------------------------------------------------------------------------
 Copyright (c) 1998-2008, Brian Gladman, Worcester, UK. All rights reserved.

 LICENSE TERMS

 The redistribution and use of this software (with or without changes)
 is allowed without the payment of fees or royalties provided that:

  1. source code distributions include the above copyright notice, this
     list of conditions and the following disclaimer;

  2. binary distributions include the above copyright notice, this list
     of conditions and the following disclaimer in their documentation;

  3. the name of the copyright holder is not used to endorse products
     built using this software without specific written permission.

 DISCLAIMER

 This software is provided 'as is' with no explicit or implied warranties
 in respect of its properties, including, but not limited to, correctness
 and/or fitness for purpose.
 ---------------------------------------------------------------------------
 Issue Date: 13/10/2006

 This code has been derived from LibTomCrypt, the cryptographic library
 authored by Tom St Denis.  His contribution is hence acknowledged. This
 code has been developed to obtain two independent implementations of the
 combined AES encryption/authentication modes (CCM, GCM and EAX) in order
 to be able to check test vectors before their publication.
*/

#ifndef LTC_OMAC_H
#define LTC_OMAC_H

#include "aes.h"

typedef struct
{
    aes_encrypt_ctx ctx[1];
    uint_8t         block[AES_BLOCK_SIZE];
    uint_8t         prev[AES_BLOCK_SIZE];
    uint_8t         lu[2][AES_BLOCK_SIZE];
    uint_32t        buflen;
} omac_state;

int omac_init( const unsigned char key[], unsigned long key_len, omac_state omac[1] );
int omac_process( const unsigned char in[], unsigned long in_len, omac_state omac[1] );
int omac_done( unsigned char out[], unsigned long *out_len, omac_state omac[1] );
int omac_memory( const unsigned char key[], unsigned long key_len,
                 const unsigned char in[], unsigned long in_len,
                 unsigned char out[], unsigned long *out_len );

#endif
