; Copyright (C) 2000 Jens Franke
; This file is part of mpqs4linux, distributed under the terms of the 
; GNU General Public Licence and WITHOUT ANY WARRANTY.

; You should have received a copy of the GNU General Public License along
; with this program; see the file COPYING.  If not, write to the Free
; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
; 02111-1307, USA.

; Modified for NASM or YASM using Intel Syntax integrated with Microsoft
; VC++ 7.1 by Brian Gladman in April 2004.  Assembler commands:
;
; nasm -Xvc -f win32 -O3 -o "$(TargetDir)\$(InputName).obj" "$(InputPath)"
; yasm -Xvc -f win32 -o "$(TargetDir)\$(InputName).obj" "$(InputPath)"

; asm_ltd(ft->FB+ft->FBsize,pbound,rtab+2*ft->FBsize),
; subsieve_interval,sievesize,ft->FB);
; Arguments:

%define FB_ptr				[ebp+ 8]
%define FB_lb				[ebp+12]
%define root_ptr			[ebp+16]
%define subsieve_interval	[ebp+20]
%define sievesize			[ebp+24]
%define FB_start			[ebp+28]
%assign	beware_double_roots	0

%include "..\mpqs-config.asm"

	text
	align	4
	
	extern	_perhaps_add2FBprimes
	global	_asm_ltd


%macro	do_a_td 2	; root return_address
	pushad
%if	beware_double_roots == 1
	cmp		ecx,ebx
	je		%2
%endif
	push	eax
	push	%1
	mov		eax,FB_ptr
	sub		eax,FB_start
	shr		eax,2
	push	eax
	xor		eax,eax
	mov		al,[edx+edi]
	dec		eax
	push	eax
	call	_perhaps_add2FBprimes
	add		esp,16
	popad
	jmp		%2

%endmacro

_asm_ltd:
	push	ebp
	mov		ebp,esp
	pushad
	mov		edi,subsieve_interval
	mov		esi,sievesize
next_prime:
	mov		edx,FB_ptr
	lea		edx,[edx-4]
	mov		eax,[edx]
	mov		FB_ptr,edx
	cmp		FB_lb,eax
	ja		ready
	mov		edx,root_ptr
	lea		edx,[edx-8]
	mov		ebx,[edx]
	mov		ecx,[edx+4]
	mov		root_ptr,edx
	cmp		esi,ecx
	jbe		final_investigation_of_root1
inner_loop:
	mov		edx,ebx
	and		edx,decremented_l1_size
	test	[edi+edx],byte 255
	jne		td_root1
after_td_root1:
	mov		edx,ecx
	and		edx,decremented_l1_size
	test	[edi+edx],byte 255
	jne		td_root2
after_td_root2:
	lea		ecx,[eax+ecx]
	lea		ebx,[eax+ebx]
	cmp		esi,ecx
	ja		inner_loop
final_investigation_of_root1:
	cmp		esi,ebx
	jbe		next_prime
	mov		edx,ebx
	and		edx,decremented_l1_size
	test	[edi+edx],byte 255
	jz		next_prime
	do_a_td	ebx,next_prime
td_root1:
	do_a_td	ebx,after_td_root1
td_root2:

%assign beware_double_roots	1
	do_a_td ecx,after_td_root2
ready:
	popad
	mov		eax,FB_ptr
	sub		eax,FB_start
	shr		eax,2
	mov		esp,ebp
	pop		ebp
	ret
	
	end
