; Copyright (C) 2000 Jens Franke
; This file is part of mpqs4linux, distributed under the terms of the 
; GNU General Public Licence and WITHOUT ANY WARRANTY.

; You should have received a copy of the GNU General Public License along
; with this program; see the file COPYING.  If not, write to the Free
; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
; 02111-1307, USA.

; Modified for NASM or YASM using Intel Syntax integrated with Microsoft
; VC++ 7.1 by Brian Gladman in April 2004.  Assembler commands:
;
; nasm -Xvc -f win32 -O3 -o "$(TargetDir)\$(InputName).obj" "$(InputPath)"
; yasm -Xvc -f win32 -o "$(TargetDir)\$(InputName).obj" "$(InputPath)"

; The function we want to write.
; void asm_schedule(FB_ptr,FBptr_ub,root_ptr,log_ptr,sievesize,schedule_ptr)

; List of stack arguments

%define FB_ptr			[ebp+ 8]
%define FBptr_ub		[ebp+12]
%define root_ptr		[ebp+16]
%define log_ptr			[ebp+20]
%define sieve_size		[ebp+24]
%define sched_ptr		[ebp+28]

%include "..\mpqs-config.asm"

%macro	ScheduleRoot 0
	mov		ecx,ebx
	shr		ecx,subsieve_shift
	mov		edx,ebx
	lea		eax,[edi+ecx*4]
	and		edx,decremented_l1_size
	mov		ecx,[eax]
	mov		[ecx],dx
	lea		ecx,[ecx+2]
	add		ebx,esi
	mov		[eax],ecx
	cmp		sieve_size,ebx
%endmacro

	text
	align	4
	
	global	_asm_schedule

_asm_schedule:
	push	ebp
	mov		ebp,esp
	pushad
	mov		edi,sched_ptr
prepare_next_prime:
	mov		ecx,FB_ptr
	mov		edx,root_ptr
	mov		esi,[ecx]
	cmp		FBptr_ub,ecx
	mov		ebx,[edx]
	jbe		finish
	lea		ecx,[ecx+4]
	mov		FB_ptr,ecx
	cmp		sieve_size,ebx
	jbe		prepare_second_root
schedule_first_root:
	ScheduleRoot
	ja		schedule_first_root
prepare_second_root:
	mov		eax,root_ptr
	mov		ebx,[eax+4]
	lea		eax,[eax+8]
	mov		root_ptr,eax
	cmp		sieve_size,ebx
	jbe		prepare_next_prime
schedule_second_root:
	ScheduleRoot
	ja		schedule_second_root
	jmp		prepare_next_prime
finish:
	popad
	mov		esp,ebp
	pop		ebp
	ret
	
	end
