; Copyright (C) 2000 Jens Franke
; This file is part of mpqs4linux, distributed under the terms of the 
; GNU General Public Licence and WITHOUT ANY WARRANTY.

; You should have received a copy of the GNU General Public License along
; with this program; see the file COPYING.  If not, write to the Free
; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
; 02111-1307, USA.

; Modified for NASM or YASM using Intel Syntax integrated with Microsoft
; VC++ 7.1 by Brian Gladman in April 2004.  Assembler commands:
;
; nasm -Xvc -f win32 -O3 -o "$(TargetDir)\$(InputName).obj" "$(InputPath)"
; yasm -Xvc -f win32 -o "$(TargetDir)\$(InputName).obj" "$(InputPath)"

; We implement the function
; asm_std1(FB_ptr,root_ptr,FB_start,candidate_i,FB_stop,candidate_nr)

%define FB_ptr			[ebp+36]
%define root_ptr		[ebp+40]
%define FB_start		[ebp+44]
%define candidate_i		[ebp+48]
%define FB_stop			[ebp+52]
%define candidate_nr	[ebp+56]

	text
	align	4
	
	extern	_add2FBprimes	
	global	_asm_std1

_asm_std1:
	pushad
	mov		ebp,esp
	mov		edi,FB_ptr
	mov		esi,root_ptr
	cmp		FB_stop,edi
	mov		ecx,candidate_i
	ja		ready
std1_loop:
	mov		eax,ecx
	xor		edx,edx
	div		dword [edi]
	cmp		[esi],edx
	je		add_to_FB_primes
	cmp		[esi+4],edx
	je		add_to_FB_primes
	lea		edi,[edi-4]
	cmp		FB_stop,edi
	lea		esi,[esi-8]
	jbe		std1_loop
ready:
	popad
	ret
	
add_to_FB_primes:
	pushad
	mov		eax,[edi]
	push	eax
	sub		edi,FB_start
	shr		edi,2
	push	edi
	mov		eax,candidate_nr
	push	eax
	call	_add2FBprimes
	add		esp,12
	popad
	lea		edi,[edi-4]
	cmp		FB_stop,edi
	lea		esi,[esi-8]
	jbe		std1_loop
	popad
	ret
	
	end
