; Copyright (C) 2000 Jens Franke
; This file is part of mpqs4linux, distributed under the terms of the 
; GNU General Public Licence and WITHOUT ANY WARRANTY.

; You should have received a copy of the GNU General Public License along
; with this program; see the file COPYING.  If not, write to the Free
; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
; 02111-1307, USA.

; Modified for NASM or YASM using Intel Syntax integrated with Microsoft
; VC++ 7.1 by Brian Gladman in April 2004.  Assembler commands:
;
; nasm -Xvc -f win32 -O3 -o "$(TargetDir)\$(InputName).obj" "$(InputPath)"
; yasm -Xvc -f win32 -o "$(TargetDir)\$(InputName).obj" "$(InputPath)"

; We implement the function
; asm_std(FB_ptr,root_ptr,FB_start,n_candidates-1)

%define FB_ptr				[ebp+36]
%define root_ptr			[ebp+40]
%define FB_start			[ebp+44]
%define last_candidate_nr	[ebp+48]
%define FB_stop				[ebp+52]

	text
	align	4
	
	extern	_PF_buf_i
	extern	_add2FBprimes	
	global _asm_std

_asm_std:
	pushad
	mov		ebp,esp
	mov		eax,last_candidate_nr
	lea		eax,[eax*4]
	mov		last_candidate_nr,eax
	jmp		next_prime
inner_loop:
	mov		eax,[ecx+_PF_buf_i]
	xor		edx,edx
	div		edi
	cmp		ebx,edx
	jz		add_to_FBprimes
	cmp		esi,edx
	jz		add_to_FBprimes
next_candidate:
	sub		ecx,4
	jae		inner_loop
next_prime:
	mov		eax,FB_ptr
	cmp		FB_stop,eax
	mov		edx,root_ptr
	mov		edi,[eax]
	mov		ebx,[edx]
	lea		eax,[eax-4]
	mov		esi,[edx+4]
	lea		edx,[edx-8]
	mov		FB_ptr,eax
	mov		root_ptr,edx
	mov		ecx,last_candidate_nr
	jbe		inner_loop
	popad
	ret
add_to_FBprimes:
	pushad
	push	edi
	mov		eax,FB_ptr
	sub		eax,FB_start
	sar		eax,2
	inc		eax
	push	eax
	shr		ecx,2
	push	ecx
	call	_add2FBprimes
	add		esp,12
	popad
	jmp		next_candidate
	
	end
